/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.nlp.annotators.spelling;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import ru.ispras.modis.utils.collections.PackedStringSet;
import ru.ispras.texterra.core.nlp.annotators.spelling.AbstractSpellingSuggester;

public class DigitReplacingSuggester
extends AbstractSpellingSuggester {
    private final Map<Character, List<String>> replacementMap;

    public DigitReplacingSuggester(PackedStringSet vocabulary, Map<Character, List<String>> replacementMap) {
        super(vocabulary);
        this.replacementMap = replacementMap;
    }

    @Override
    protected boolean canBeCorrected(String incorrectWord) {
        return incorrectWord.matches(".*\\d.*");
    }

    @Override
    protected List<String> getSuggestions(String incorrectWord) {
        LinkedList<String> variants = new LinkedList<String>();
        variants.add("");
        for (int i = 0; i < incorrectWord.length(); ++i) {
            char currentChar = incorrectWord.charAt(i);
            LinkedList<String> subVariants = new LinkedList<String>();
            for (String variant : variants) {
                if (Character.isDigit(currentChar)) {
                    for (String replacement : this.replacementMap.get(Character.valueOf(currentChar))) {
                        subVariants.add(variant + replacement);
                    }
                    continue;
                }
                subVariants.add(variant + currentChar);
            }
            variants = subVariants;
        }
        return variants;
    }
}

