/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.nlp.annotators.spelling;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import ru.ispras.modis.utils.collections.PackedStringSet;
import ru.ispras.texterra.core.nlp.annotators.spelling.AbstractSpellingSuggester;

public class CommonTyposCorrectingSuggester
extends AbstractSpellingSuggester {
    private final char[] alphabet;
    private final int maxEditDistance;

    public CommonTyposCorrectingSuggester(PackedStringSet vocabulary, char[] alphabet, int maxEditDistance) {
        super(vocabulary);
        this.alphabet = alphabet;
        assert (maxEditDistance > 0);
        this.maxEditDistance = maxEditDistance;
    }

    @Override
    protected List<String> getSuggestions(String incorrectWord) {
        LinkedList<String> res = new LinkedList<String>();
        List<String> current = Arrays.asList(incorrectWord);
        for (int iter = 0; iter < this.maxEditDistance; ++iter) {
            LinkedList<String> next = new LinkedList<String>();
            for (String word : current) {
                next.addAll(this.correctOneTypo(word));
            }
            current = next;
            res.addAll(current);
        }
        return res;
    }

    private List<String> correctOneTypo(String incorrectWord) {
        int i;
        LinkedList<String> res = new LinkedList<String>();
        for (i = 0; i < incorrectWord.length(); ++i) {
            res.add(incorrectWord.substring(0, i) + incorrectWord.substring(i + 1));
        }
        for (i = 0; i < incorrectWord.length() - 1; ++i) {
            res.add(incorrectWord.substring(0, i) + incorrectWord.charAt(i + 1) + incorrectWord.charAt(i) + incorrectWord.substring(i + 2));
        }
        for (i = 0; i < incorrectWord.length(); ++i) {
            for (char c : this.alphabet) {
                res.add(incorrectWord.substring(0, i) + c + incorrectWord.substring(i + 1));
            }
        }
        for (i = 0; i <= incorrectWord.length(); ++i) {
            for (char c : this.alphabet) {
                res.add(incorrectWord.substring(0, i) + c + incorrectWord.substring(i));
            }
        }
        return res;
    }
}

