/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.nlp.annotators.spelling;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.collections15.CollectionUtils;
import org.apache.commons.collections15.Predicate;
import ru.ispras.modis.utils.collections.PackedStringSet;
import ru.ispras.texterra.core.nlp.annotators.IAnnotator;
import ru.ispras.texterra.core.nlp.datamodel.IAnnotation;
import ru.ispras.texterra.core.nlp.datamodel.INLPDocument;
import ru.ispras.texterra.core.nlp.datamodel.spelling.Misspelling;
import ru.ispras.texterra.core.nlp.datamodel.spelling.SpellingSuggestion;

public abstract class AbstractSpellingSuggester
implements IAnnotator<SpellingSuggestion> {
    protected final PackedStringSet vocabulary;
    protected final Predicate<String> containedInVocabulary = new Predicate<String>(){

        public boolean evaluate(String str) {
            return AbstractSpellingSuggester.this.vocabulary.contains(str);
        }
    };

    protected AbstractSpellingSuggester(PackedStringSet vocabulary) {
        this.vocabulary = vocabulary;
    }

    protected boolean canBeCorrected(String incorrectWord) {
        return true;
    }

    protected abstract List<String> getSuggestions(String var1);

    @Override
    public Collection<SpellingSuggestion> annotate(INLPDocument doc) {
        LinkedList<SpellingSuggestion> res = new LinkedList<SpellingSuggestion>();
        for (Misspelling misspelling : doc.getAnnotations(Misspelling.class)) {
            if (!this.canBeCorrected(misspelling.getText())) continue;
            List<String> suggestions = this.getSuggestions(misspelling.getText());
            CollectionUtils.filter(suggestions, this.containedInVocabulary);
            for (String suggestion : suggestions) {
                res.add(new SpellingSuggestion((IAnnotation)misspelling, suggestion));
            }
        }
        return res;
    }
}

