/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.nlp.annotators.sentiment.subjectivity;

import java.util.Collection;
import java.util.Collections;
import ru.ispras.ml.pipelines.PredictionPipeline;
import ru.ispras.texterra.core.nlp.annotators.ISerializableAnnotator;
import ru.ispras.texterra.core.nlp.datamodel.INLPDocument;
import ru.ispras.texterra.core.nlp.datamodel.SentimentSubjectivity;

public class SubjectivityDetector
implements ISerializableAnnotator<SentimentSubjectivity> {
    private static final long serialVersionUID = -805554487069685992L;
    private final PredictionPipeline<INLPDocument, Boolean> predictor;

    protected SubjectivityDetector(PredictionPipeline<INLPDocument, Boolean> predictor) {
        this.predictor = predictor;
    }

    @Override
    public Collection<SentimentSubjectivity> annotate(INLPDocument doc) {
        boolean isSubjective = (Boolean)this.predictor.apply((Object)doc).getLabel();
        if (isSubjective) {
            return Collections.singletonList(new SentimentSubjectivity(doc));
        }
        return Collections.emptyList();
    }
}

