/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.nlp.annotators.sentiment.polarity;

import java.util.Iterator;
import ru.ispras.ml.pipelines.SourceLabelPair;
import ru.ispras.texterra.core.nlp.annotators.IAnnotatorTrainer;
import ru.ispras.texterra.core.nlp.annotators.ml.pipelines.PredictionPipelineTrainer;
import ru.ispras.texterra.core.nlp.annotators.sentiment.polarity.PolarityDetector;
import ru.ispras.texterra.core.nlp.datamodel.INLPDocument;
import ru.ispras.texterra.core.nlp.datamodel.SentimentPolarity;

public class PolarityDetectorTrainer
implements IAnnotatorTrainer<PolarityDetector> {
    private final PredictionPipelineTrainer<INLPDocument, SentimentPolarity.Direction> predictorTrainer;

    public PolarityDetectorTrainer(PredictionPipelineTrainer<INLPDocument, SentimentPolarity.Direction> predictorTrainer) {
        this.predictorTrainer = predictorTrainer;
    }

    @Override
    public PolarityDetector train(Iterable<INLPDocument> documents) {
        SourcesLabelsIterable sourcesLabels = new SourcesLabelsIterable(documents);
        return new PolarityDetector(this.predictorTrainer.train(sourcesLabels));
    }

    private static class SourcesLabelsIterable
    implements Iterable<SourceLabelPair<INLPDocument, SentimentPolarity.Direction>> {
        private final Iterable<INLPDocument> documents;

        public SourcesLabelsIterable(Iterable<INLPDocument> documents) {
            this.documents = documents;
        }

        @Override
        public Iterator<SourceLabelPair<INLPDocument, SentimentPolarity.Direction>> iterator() {
            final Iterator<INLPDocument> documentsIt = this.documents.iterator();
            return new Iterator<SourceLabelPair<INLPDocument, SentimentPolarity.Direction>>(){

                @Override
                public boolean hasNext() {
                    return documentsIt.hasNext();
                }

                @Override
                public SourceLabelPair<INLPDocument, SentimentPolarity.Direction> next() {
                    INLPDocument doc = (INLPDocument)documentsIt.next();
                    SentimentPolarity polarity = doc.getAnnotations(SentimentPolarity.class).get(0);
                    return new SourceLabelPair((Object)doc, polarity.getValue());
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }
}

