/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.nlp.annotators.pos;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import ru.ispras.texterra.core.nlp.annotators.ISerializableAnnotator;
import ru.ispras.texterra.core.nlp.datamodel.IAnnotation;
import ru.ispras.texterra.core.nlp.datamodel.INLPDocument;
import ru.ispras.texterra.core.nlp.datamodel.pos.GeneralPOSTag;
import ru.ispras.texterra.core.nlp.datamodel.pos.IPOSTag;
import ru.ispras.texterra.core.nlp.datamodel.pos.POSToken;
import ru.ispras.texterra.core.nlp.datamodel.pos.morph.MorphProperties;
import ru.ispras.texterra.core.nlp.datamodel.pos.morph.characters.IMorphCharacter;

public class GeneralPOSTagger
implements ISerializableAnnotator<POSToken> {
    private static final long serialVersionUID = -3349713012368923209L;

    @Override
    public Collection<POSToken> annotate(INLPDocument doc) {
        List<POSToken> posTokens = doc.getAnnotations(POSToken.class);
        ArrayList<POSToken> result = new ArrayList<POSToken>(posTokens.size());
        for (POSToken posToken : posTokens) {
            result.add(this.convertPOSToken(posToken));
        }
        return result;
    }

    private POSToken convertPOSToken(POSToken posToken) {
        return new POSToken((IAnnotation)posToken, new MorphProperties((IPOSTag)GeneralPOSTag.getGeneralTag((IPOSTag)posToken.getValue()), new IMorphCharacter[0]));
    }
}

