/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.nlp.annotators.pos;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ru.ispras.texterra.core.nlp.annotators.ISerializableAnnotator;
import ru.ispras.texterra.core.nlp.datamodel.IAnnotation;
import ru.ispras.texterra.core.nlp.datamodel.INLPDocument;
import ru.ispras.texterra.core.nlp.datamodel.pos.POSToken;
import ru.ispras.texterra.core.nlp.datamodel.pos.morph.IMorphProperties;
import ru.ispras.texterra.core.nlp.datamodel.pos.morph.MorphProperties;
import ru.ispras.texterra.core.nlp.datamodel.pos.morph.characters.IMorphCharacter;

public class FilteringMorphCharactersPOSTagger
implements ISerializableAnnotator<POSToken> {
    private static final long serialVersionUID = 2588781320133984194L;
    private final Set<Class<? extends IMorphCharacter>> morphCharacterClasses;

    @SafeVarargs
    public FilteringMorphCharactersPOSTagger(Class<? extends IMorphCharacter> ... morphCharacterClasses) {
        this.morphCharacterClasses = new HashSet<Class<? extends IMorphCharacter>>(Arrays.asList(morphCharacterClasses));
    }

    @Override
    public Collection<POSToken> annotate(INLPDocument doc) {
        List<POSToken> posTokens = doc.getAnnotations(POSToken.class);
        ArrayList<POSToken> result = new ArrayList<POSToken>(posTokens.size());
        for (POSToken posToken : posTokens) {
            result.add(this.convert(posToken));
        }
        return result;
    }

    private POSToken convert(POSToken posToken) {
        IMorphProperties posTag = (IMorphProperties)posToken.getValue();
        return new POSToken((IAnnotation)posToken, new MorphProperties(posTag.getPOSTag(), this.filterMorphCharacters(posTag.getMorphCharacters())));
    }

    private List<IMorphCharacter> filterMorphCharacters(Collection<IMorphCharacter> morphCharacters) {
        ArrayList<IMorphCharacter> result = new ArrayList<IMorphCharacter>();
        for (IMorphCharacter morphCharacter : morphCharacters) {
            if (!this.morphCharacterClasses.contains(morphCharacter.getClass())) continue;
            result.add(morphCharacter);
        }
        return result;
    }
}

