/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.nlp.annotators.ne.ml.featureextractors;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections15.Predicate;
import ru.ispras.ml.datamodel.Feature;
import ru.ispras.ml.datamodel.value.BooleanValue;
import ru.ispras.ml.datamodel.value.IValue;
import ru.ispras.ml.datamodel.value.Type;
import ru.ispras.ml.featureextractors.IFeatureExtractor;
import ru.ispras.modis.utils.predicates.characters.IsDigitCharacterPredicate;
import ru.ispras.modis.utils.predicates.strings.AnyCharacterStringPredicate;
import ru.ispras.texterra.core.nlp.datamodel.IToken;

public final class TokenDigitNormalizationFeatureExtractor
implements IFeatureExtractor<IToken> {
    private static final long serialVersionUID = -1772554162727602452L;
    private final Predicate<String> hasDigitsPredicate = new AnyCharacterStringPredicate((Predicate)new IsDigitCharacterPredicate());

    public Map<Feature, IValue> extract(IToken token) {
        String form = (String)token.getValue();
        HashMap<Feature, IValue> featuresValues = new HashMap<Feature, IValue>();
        if (this.hasDigitsPredicate.evaluate((Object)form)) {
            featuresValues.put(new Feature(this.normalizeDigits(form), Type.BOOLEAN), (IValue)BooleanValue.TRUE);
        }
        return featuresValues;
    }

    private String normalizeDigits(String token) {
        StringBuffer result = new StringBuffer(token.length() * 2 + 1);
        boolean isOpened = false;
        for (int i = 0; i < token.length(); ++i) {
            char c = token.charAt(i);
            if (Character.isDigit(c)) {
                if (!isOpened) {
                    result.append('*');
                    isOpened = true;
                }
                result.append("D");
                continue;
            }
            if (isOpened) {
                result.append('*');
                isOpened = false;
            }
            result.append(c);
        }
        if (isOpened) {
            result.append('*');
        }
        return result.toString();
    }
}

