/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.nlp.annotators.ne.encoding;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import ru.ispras.texterra.core.nlp.annotators.ISerializableAnnotator;
import ru.ispras.texterra.core.nlp.datamodel.IAnnotation;
import ru.ispras.texterra.core.nlp.datamodel.INLPDocument;
import ru.ispras.texterra.core.nlp.datamodel.IToken;
import ru.ispras.texterra.core.nlp.datamodel.encoding.BILUChunkEncoding;
import ru.ispras.texterra.core.nlp.datamodel.ne.INamedEntity;
import ru.ispras.texterra.core.nlp.datamodel.ne.NamedEntityToken;
import ru.ispras.texterra.core.nlp.datamodel.ne.encoding.INamedEntityEncoding;
import ru.ispras.texterra.core.nlp.datamodel.ne.encoding.NamedEntityEncoding;
import ru.ispras.texterra.core.nlp.datamodel.ne.encoding.NamedEntityEncodingToken;
import ru.ispras.texterra.core.nlp.datamodel.ne.encoding.OutOfNamedEntityEncoding;

public final class BILUNamedEntityEncoder
implements ISerializableAnnotator<NamedEntityEncodingToken> {
    private static final long serialVersionUID = -4752895645507203442L;

    @Override
    public Collection<NamedEntityEncodingToken> annotate(INLPDocument doc) {
        ArrayList<NamedEntityEncodingToken> result = new ArrayList<NamedEntityEncodingToken>();
        Iterator<IToken> tokensIt = doc.getAnnotations(IToken.class).iterator();
        Iterator<NamedEntityToken> entityTokensIt = doc.getAnnotations(NamedEntityToken.class).iterator();
        this.processEntities(result, tokensIt, entityTokensIt);
        this.processTokensAfterEntities(result, tokensIt);
        return result;
    }

    private void processEntities(Collection<NamedEntityEncodingToken> result, Iterator<IToken> tokensIt, Iterator<NamedEntityToken> entityTokensIt) {
        while (entityTokensIt.hasNext()) {
            this.processEntity(result, tokensIt, entityTokensIt.next());
        }
    }

    private void processEntity(Collection<NamedEntityEncodingToken> result, Iterator<IToken> tokensIt, NamedEntityToken entityToken) {
        boolean endOfEntity;
        while (tokensIt.hasNext() && !(endOfEntity = this.processToken(result, tokensIt.next(), entityToken))) {
        }
    }

    private boolean processToken(Collection<NamedEntityEncodingToken> result, IToken token, NamedEntityToken entityToken) {
        boolean endOfEntity = this.isTokenAtEndOfEntity(token, entityToken);
        if (token.getEnd() <= entityToken.getStart()) {
            this.processTokenOutsideOfEntity(result, token);
        } else if (token.getStart() <= entityToken.getStart()) {
            this.processTokenAtStartOfEntity(result, token, entityToken, endOfEntity);
        } else {
            this.processTokenAtMiddleOfEntity(result, entityToken, token, endOfEntity);
        }
        return endOfEntity;
    }

    private boolean isTokenAtEndOfEntity(IToken token, NamedEntityToken entityToken) {
        return token.getEnd() >= entityToken.getEnd();
    }

    private void processTokenAtStartOfEntity(Collection<NamedEntityEncodingToken> result, IToken token, NamedEntityToken entityToken, boolean endOfEntity) {
        result.add(new NamedEntityEncodingToken((IAnnotation)token, (INamedEntityEncoding)new NamedEntityEncoding((INamedEntity)entityToken.getValue(), endOfEntity ? BILUChunkEncoding.U : BILUChunkEncoding.B)));
    }

    private void processTokenAtMiddleOfEntity(Collection<NamedEntityEncodingToken> result, NamedEntityToken entityToken, IToken token, boolean endOfEntity) {
        result.add(new NamedEntityEncodingToken((IAnnotation)token, (INamedEntityEncoding)new NamedEntityEncoding((INamedEntity)entityToken.getValue(), endOfEntity ? BILUChunkEncoding.L : BILUChunkEncoding.I)));
    }

    private void processTokensAfterEntities(Collection<NamedEntityEncodingToken> result, Iterator<IToken> tokensIt) {
        while (tokensIt.hasNext()) {
            IToken token = tokensIt.next();
            this.processTokenOutsideOfEntity(result, token);
        }
    }

    private void processTokenOutsideOfEntity(Collection<NamedEntityEncodingToken> result, IToken token) {
        result.add(new NamedEntityEncodingToken((IAnnotation)token, (INamedEntityEncoding)new OutOfNamedEntityEncoding()));
    }
}

