/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.nlp.annotators.ml.featureextractors.spaceconverters;

import java.util.Collections;
import java.util.Map;
import ru.ispras.ml.datamodel.Feature;
import ru.ispras.ml.datamodel.value.IValue;
import ru.ispras.ml.datamodel.value.IntValue;
import ru.ispras.ml.datamodel.value.Type;
import ru.ispras.ml.featureextractors.IFeatureExtractor;

public final class SummarizingIntegerFeatureSpaceConverter
implements IFeatureExtractor<Map<Feature, IValue>> {
    private static final long serialVersionUID = -3424854845819339806L;
    private static final Feature feature = new Feature("feature", Type.INTEGER);

    public Map<Feature, IValue> extract(Map<Feature, IValue> instance) {
        int sum = 0;
        for (Map.Entry<Feature, IValue> featureAndValue : instance.entrySet()) {
            IValue value = featureAndValue.getValue();
            if (value.hasInt()) {
                sum += value.getInt();
                continue;
            }
            throw new IllegalArgumentException("Integer features are supported only.");
        }
        return Collections.singletonMap(feature, new IntValue(sum));
    }
}

