/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.nlp.annotators.ml.featureextractors.spaceconverters;

import java.util.HashMap;
import java.util.Map;
import ru.ispras.ml.datamodel.Feature;
import ru.ispras.ml.datamodel.value.BooleanValue;
import ru.ispras.ml.datamodel.value.IValue;
import ru.ispras.ml.datamodel.value.Type;
import ru.ispras.ml.featureextractors.IFeatureExtractor;

public final class NumberToBooleanFeatureSpaceConverter
implements IFeatureExtractor<Map<Feature, IValue>> {
    private static final long serialVersionUID = 8498687628816224324L;

    public Map<Feature, IValue> extract(Map<Feature, IValue> instance) {
        HashMap<Feature, IValue> featuresValues = new HashMap<Feature, IValue>();
        for (Map.Entry<Feature, IValue> featureAndValue : instance.entrySet()) {
            Feature feature = featureAndValue.getKey();
            IValue value = featureAndValue.getValue();
            featuresValues.put(new Feature(feature.getName(), Type.BOOLEAN), this.getBooleanValue(value));
        }
        return featuresValues;
    }

    private IValue getBooleanValue(IValue value) {
        if (value.hasBoolean()) {
            return value;
        }
        if (value.hasInt()) {
            return BooleanValue.of((value.getInt() != 0 ? 1 : 0) != 0);
        }
        if (value.hasDouble()) {
            return BooleanValue.of((Math.abs(value.getDouble()) >= Double.MIN_VALUE ? 1 : 0) != 0);
        }
        throw new IllegalArgumentException("Double, integer and boolean features are supported only.");
    }
}

