/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.nlp.annotators.ml.featureextractors.jim;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import ru.ispras.texterra.core.nlp.annotators.ml.featureextractors.jim.FilteringThresholds;
import ru.ispras.texterra.core.nlp.annotators.ml.featureextractors.jim.ItemDatabase;
import ru.ispras.texterra.core.nlp.annotators.ml.featureextractors.jim.ItemTransactions;

public final class ItemDatabaseFactory {
    public <T> ItemDatabase<T> create(Collection<Set<T>> items, FilteringThresholds thresholdsConfig) {
        return new ItemDatabase<T>(this.computeItemTransactions(items, thresholdsConfig));
    }

    private <T> List<ItemTransactions<T>> computeItemTransactions(Collection<Set<T>> items, FilteringThresholds thresholdsConfig) {
        AtomicInteger id = new AtomicInteger();
        Map byItem = items.stream().flatMap(set -> this.composePairs(id.incrementAndGet(), (Set)set)).collect(Collectors.groupingBy(e -> e.getFirst(), Collectors.mapping(e -> (Integer)e.getSecond(), Collectors.toList())));
        int minThreshold = thresholdsConfig.getMinThreshold(id.get());
        int maxThreshold = thresholdsConfig.getMaxThreshold(id.get());
        return byItem.entrySet().stream().filter(e -> ((List)e.getValue()).size() >= minThreshold).filter(e -> ((List)e.getValue()).size() <= maxThreshold).map(e -> new Pair(e.getKey(), ((List)e.getValue()).stream().sorted().collect(Collectors.toList()))).map(p -> new ItemTransactions(p.getFirst(), new ArrayList<Integer>((Collection)p.getSecond()), new ArrayList<Integer>((Collection)p.getSecond()))).collect(Collectors.toList());
    }

    private <T> Stream<Pair<T, Integer>> composePairs(int id, Set<T> items) {
        return items.stream().map(item -> new Pair<Object, Integer>(item, id));
    }

    static final class Pair<F, S> {
        private final F first;
        private final S second;

        public Pair(F first, S second) {
            this.first = first;
            this.second = second;
        }

        public F getFirst() {
            return this.first;
        }

        public S getSecond() {
            return this.second;
        }
    }
}

