/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.nlp.annotators.ml.featureextractors.jim;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import ru.ispras.ml.datamodel.Feature;
import ru.ispras.ml.datamodel.value.BooleanValue;
import ru.ispras.ml.datamodel.value.IValue;
import ru.ispras.ml.datamodel.value.Type;
import ru.ispras.texterra.core.nlp.annotators.ml.featureextractors.jim.ICompositeFeatureExtractor;

public final class ExactMatchCompositeFeatureExtractor
implements ICompositeFeatureExtractor {
    private static final long serialVersionUID = 5375764843312052276L;
    private static final Feature EXACT_MATCH = new Feature("", Type.BOOLEAN);
    private static final Feature NON_FULL_SET = new Feature("", Type.BOOLEAN);
    private final Map<Feature, IValue> selectedFeatures;

    public ExactMatchCompositeFeatureExtractor(Map<Feature, IValue> selectedFeatures) {
        this.selectedFeatures = new HashMap<Feature, IValue>(selectedFeatures);
    }

    public Map<Feature, IValue> extract(Map<Feature, IValue> input) {
        boolean match = true;
        for (Map.Entry<Feature, IValue> entry : this.selectedFeatures.entrySet()) {
            IValue inputValue = input.get(entry.getKey());
            if (inputValue == null) {
                return Collections.singletonMap(NON_FULL_SET, BooleanValue.TRUE);
            }
            match &= entry.getValue().equals(inputValue);
        }
        return Collections.singletonMap(EXACT_MATCH, BooleanValue.of((boolean)match));
    }

    @Override
    public Set<Feature> getParticipatingFeatures() {
        return Collections.unmodifiableSet(this.selectedFeatures.keySet());
    }
}

