/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.nlp.annotators.ml.featureextractors.jim;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import ru.ispras.ml.datamodel.Feature;
import ru.ispras.ml.datamodel.value.DoubleValue;
import ru.ispras.ml.datamodel.value.IValue;
import ru.ispras.ml.datamodel.value.Type;
import ru.ispras.texterra.core.nlp.annotators.ml.featureextractors.jim.ICompositeFeatureExtractor;

public final class ConcatValuesCompositeFeatureExtractor
implements ICompositeFeatureExtractor {
    private static final long serialVersionUID = 1106299315489324305L;
    private static final IValue VALUE = new DoubleValue(1.0);
    private final List<Feature> features;

    public ConcatValuesCompositeFeatureExtractor(List<Feature> features) {
        this.features = new ArrayList<Feature>(features);
    }

    public Map<Feature, IValue> extract(Map<Feature, IValue> input) {
        List values = this.features.stream().map(f -> (IValue)input.get(f)).filter(v -> v != null).collect(Collectors.toList());
        if (values.size() == this.features.size()) {
            return Collections.singletonMap(new Feature(values.toString(), Type.DOUBLE), VALUE);
        }
        return Collections.emptyMap();
    }

    @Override
    public Set<Feature> getParticipatingFeatures() {
        return Collections.unmodifiableSet(new HashSet<Feature>(this.features));
    }
}

