/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.nlp.annotators.ml.featureextractors.documents.contextextractors;

import java.util.ArrayList;
import java.util.List;
import ru.ispras.texterra.core.nlp.annotators.ml.featureextractors.contextextractors.IContextExtractor;
import ru.ispras.texterra.core.nlp.datamodel.IToken;
import ru.ispras.texterra.core.nlp.datamodel.NLPDocumentWithAnnotation;

public final class IsSameTokenIgnoreCaseContextExtractor
implements IContextExtractor<NLPDocumentWithAnnotation<IToken>, IToken> {
    private static final long serialVersionUID = 6539488766654392396L;
    private final IContextExtractor<NLPDocumentWithAnnotation<IToken>, IToken> wrapped;

    public IsSameTokenIgnoreCaseContextExtractor(IContextExtractor<NLPDocumentWithAnnotation<IToken>, IToken> wrapped) {
        this.wrapped = wrapped;
    }

    @Override
    public List<IToken> extract(NLPDocumentWithAnnotation<IToken> document) {
        IToken token = document.getAnnotation();
        List<IToken> context = this.wrapped.extract(document);
        ArrayList<IToken> result = new ArrayList<IToken>();
        for (IToken contextElement : context) {
            if (!this.isSameTokenIgnoreCase(token, contextElement)) continue;
            result.add(contextElement);
        }
        return result;
    }

    private boolean isSameTokenIgnoreCase(IToken token, IToken contextElement) {
        return ((String)token.getValue()).equalsIgnoreCase((String)contextElement.getValue());
    }
}

