/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.nlp.annotators.ml.featureextractors.documents;

import java.util.ArrayList;
import ru.ispras.ml.featureextractors.IFeatureExtractor;
import ru.ispras.texterra.core.nlp.annotators.ml.featureextractors.ContextFeatureExtractor;
import ru.ispras.texterra.core.nlp.annotators.ml.featureextractors.StackFeatureExtractor;
import ru.ispras.texterra.core.nlp.annotators.ml.featureextractors.UnionFeatureExtractor;
import ru.ispras.texterra.core.nlp.annotators.ml.featureextractors.contextextractors.IContextExtractor;
import ru.ispras.texterra.core.nlp.annotators.ml.featureextractors.documents.contextextractors.WindowContextExtractor;
import ru.ispras.texterra.core.nlp.annotators.ml.featureextractors.documents.contextextractors.WithDocumentContextExtractor;
import ru.ispras.texterra.core.nlp.annotators.ml.featureextractors.documents.contextextractors.windowextractors.IWindowExtractor;
import ru.ispras.texterra.core.nlp.annotators.ml.featureextractors.documents.contextextractors.windowextractors.LeftWindowExtractor;
import ru.ispras.texterra.core.nlp.annotators.ml.featureextractors.documents.contextextractors.windowextractors.RightWindowExtractor;
import ru.ispras.texterra.core.nlp.datamodel.IAnnotation;
import ru.ispras.texterra.core.nlp.datamodel.NLPDocumentWithAnnotation;

public final class WindowFeatureExtractorFactoryUtils {
    public static <A extends IAnnotation> IFeatureExtractor<NLPDocumentWithAnnotation<A>> createFullWindowFeatureExtractor(IFeatureExtractor<NLPDocumentWithAnnotation<A>> featureExtractor, IContextExtractor<NLPDocumentWithAnnotation<A>, A> contextExtractor, int leftWindowSize, int rightWindowSize) {
        ArrayList<IFeatureExtractor<NLPDocumentWithAnnotation<A>>> result = new ArrayList<IFeatureExtractor<NLPDocumentWithAnnotation<A>>>(3);
        result.add(featureExtractor);
        if (leftWindowSize > 0) {
            result.add(WindowFeatureExtractorFactoryUtils.createWindowFeatureExtractor(featureExtractor, contextExtractor, new LeftWindowExtractor(leftWindowSize)));
        }
        if (rightWindowSize > 0) {
            result.add(WindowFeatureExtractorFactoryUtils.createWindowFeatureExtractor(featureExtractor, contextExtractor, new RightWindowExtractor(rightWindowSize)));
        }
        return new UnionFeatureExtractor<NLPDocumentWithAnnotation<A>>(result);
    }

    public static <A extends IAnnotation> IFeatureExtractor<NLPDocumentWithAnnotation<A>> createFullWindowFeatureExtractor(IFeatureExtractor<NLPDocumentWithAnnotation<A>> featureExtractor, IContextExtractor<NLPDocumentWithAnnotation<A>, A> contextExtractor, int windowSize) {
        return WindowFeatureExtractorFactoryUtils.createFullWindowFeatureExtractor(featureExtractor, contextExtractor, windowSize, windowSize);
    }

    private static <A extends IAnnotation> IFeatureExtractor<NLPDocumentWithAnnotation<A>> createWindowFeatureExtractor(IFeatureExtractor<NLPDocumentWithAnnotation<A>> featureExtractor, IContextExtractor<NLPDocumentWithAnnotation<A>, A> contextExtractor, IWindowExtractor<A> windowExtractor) {
        return new ContextFeatureExtractor(new WithDocumentContextExtractor(new WindowContextExtractor<A>(contextExtractor, windowExtractor)), new StackFeatureExtractor<NLPDocumentWithAnnotation<A>>(featureExtractor));
    }
}

