/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.nlp.annotators.ml.featureextractors.documents;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import ru.ispras.ml.datamodel.Feature;
import ru.ispras.ml.datamodel.value.DoubleValue;
import ru.ispras.ml.datamodel.value.IValue;
import ru.ispras.ml.datamodel.value.Type;
import ru.ispras.ml.featureextractors.IFeatureExtractor;
import ru.ispras.texterra.core.nlp.datamodel.IAnnotation;
import ru.ispras.texterra.core.nlp.datamodel.IValuedAnnotation;
import ru.ispras.texterra.core.nlp.datamodel.NLPDocumentWithAnnotation;

public final class TFFeatureExtractor<A extends IAnnotation, T>
implements IFeatureExtractor<NLPDocumentWithAnnotation<A>> {
    private static final long serialVersionUID = 1544886565889348742L;
    private static final Feature FEATURE = new Feature("tf", Type.DOUBLE);
    private final Class<A> type;
    private final Function<A, T> termExtractor;

    public TFFeatureExtractor(Class<A> type, Function<A, T> termExtractor) {
        this.type = type;
        this.termExtractor = termExtractor;
    }

    public Map<Feature, IValue> extract(NLPDocumentWithAnnotation<A> docWithAnn) {
        List<A> annotations = docWithAnn.getDocument().getAnnotations(this.type);
        Object term = this.termExtractor.apply(docWithAnn.getAnnotation());
        long count = annotations.stream().map(this.termExtractor).filter(t -> term.equals(t)).count();
        return Collections.singletonMap(FEATURE, new DoubleValue((double)count / (double)annotations.size()));
    }

    public static final class ValueTermExtractor<A extends IValuedAnnotation<V>, V>
    implements Function<A, V>,
    Serializable {
        private static final long serialVersionUID = -2487415994261972089L;

        @Override
        public V apply(A annotation) {
            return annotation.getValue();
        }
    }
}

