/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.nlp.annotators.ml.featureextractors.annotations.tokens;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.Validate;
import ru.ispras.ml.datamodel.Feature;
import ru.ispras.ml.datamodel.value.BooleanValue;
import ru.ispras.ml.datamodel.value.IValue;
import ru.ispras.ml.datamodel.value.Type;
import ru.ispras.ml.featureextractors.IFeatureExtractor;
import ru.ispras.texterra.core.nlp.datamodel.IToken;

public final class TokenPrefixFormFeatureExtractor
implements IFeatureExtractor<IToken> {
    private static final long serialVersionUID = 6355164271640656549L;
    private final int prefixLength;

    public TokenPrefixFormFeatureExtractor(int prefixLength) {
        Validate.isTrue((prefixLength > 0 ? 1 : 0) != 0);
        this.prefixLength = prefixLength;
    }

    public Map<Feature, IValue> extract(IToken token) {
        String form = (String)token.getValue();
        HashMap<Feature, IValue> featuresValues = new HashMap<Feature, IValue>();
        if (form.length() >= this.prefixLength) {
            featuresValues.put(new Feature(form.substring(0, this.prefixLength), Type.BOOLEAN), (IValue)BooleanValue.TRUE);
        }
        return featuresValues;
    }
}

