/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.nlp.annotators.ml.featureextractors;

import java.util.HashMap;
import java.util.Map;
import ru.ispras.ml.datamodel.Feature;
import ru.ispras.ml.datamodel.value.IValue;
import ru.ispras.ml.featureextractors.IFeatureExtractor;
import ru.ispras.modis.utils.DoubleUtils;

public final class SparcifyingFeatureExtractor<S>
implements IFeatureExtractor<S> {
    private static final long serialVersionUID = 2693682366585280921L;
    private final IFeatureExtractor<S> wrapped;

    public SparcifyingFeatureExtractor(IFeatureExtractor<S> wrapped) {
        this.wrapped = wrapped;
    }

    public Map<Feature, IValue> extract(S source) {
        Map instance = this.wrapped.extract(source);
        HashMap<Feature, IValue> featuresValues = new HashMap<Feature, IValue>();
        for (Map.Entry featureValue : instance.entrySet()) {
            IValue value;
            Feature feature = (Feature)featureValue.getKey();
            if (!this.hasNonZeroValue(feature, value = (IValue)featureValue.getValue())) continue;
            featuresValues.put(feature, value);
        }
        return featuresValues;
    }

    private boolean hasNonZeroValue(Feature feature, IValue value) {
        switch (feature.getType()) {
            case BOOLEAN: {
                return value.getBoolean();
            }
            case INTEGER: {
                return value.getInt() != 0;
            }
            case DOUBLE: {
                return !DoubleUtils.doubleNanoEquals((double)value.getDouble(), (double)0.0);
            }
        }
        throw new IllegalStateException("Only boolean, integer and double features are supported.");
    }
}

