/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.nlp.annotators.lemmatizer.model;

import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import ru.ispras.texterra.core.nlp.annotators.lemmatizer.model.CharTrieNode;
import ru.ispras.texterra.core.nlp.annotators.lemmatizer.wordProcessors.IWordPreProcessor;
import ru.ispras.texterra.core.nlp.datamodel.pos.IPOSTag;

public class LemmaGenModel
implements Serializable {
    private static final long serialVersionUID = -2684367530898906509L;
    private final IWordPreProcessor preProcessor;
    private final Map<IPOSTag, CharTrieNode> model;
    private final char endOfWordChar;

    public LemmaGenModel(IWordPreProcessor preProcessor, Map<IPOSTag, CharTrieNode> model, char endOfWordChar) {
        assert (preProcessor != null);
        assert (model != null);
        this.preProcessor = preProcessor;
        this.model = model;
        this.endOfWordChar = endOfWordChar;
    }

    public CharTrieNode getRootNode(IPOSTag posTag) {
        return this.model.get(posTag);
    }

    public Set<IPOSTag> getPOSTags() {
        return this.model.keySet();
    }

    public IWordPreProcessor getWordPreProcessor() {
        return this.preProcessor;
    }

    public char getEndOfWordChar() {
        return this.endOfWordChar;
    }
}

