/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.nlp.annotators.context;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Set;
import ru.ispras.texterra.core.common.concept.Concept;
import ru.ispras.texterra.core.nlp.annotators.ISerializableAnnotator;
import ru.ispras.texterra.core.nlp.datamodel.INLPDocument;
import ru.ispras.texterra.core.nlp.datamodel.IWeightedSemanticContextValue;
import ru.ispras.texterra.core.nlp.datamodel.MeaningPhrase;
import ru.ispras.texterra.core.nlp.datamodel.SingleSenceSemanticContext;
import ru.ispras.texterra.core.nlp.datamodel.WeightedSemanticContextValue;

public final class SingleSenceContextAnnotator
implements ISerializableAnnotator<SingleSenceSemanticContext> {
    private static final long serialVersionUID = -7394053122904777149L;

    @Override
    public Collection<SingleSenceSemanticContext> annotate(INLPDocument doc) {
        LinkedList<Concept> conceptlist = new LinkedList<Concept>();
        for (MeaningPhrase phrase : doc.getAnnotations(MeaningPhrase.class)) {
            Set<Concept> meanings = phrase.getMeanings();
            if (meanings.size() != 1) continue;
            conceptlist.addAll(meanings);
        }
        return Collections.singletonList(new SingleSenceSemanticContext(doc, (IWeightedSemanticContextValue)new WeightedSemanticContextValue(conceptlist)));
    }
}

