/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.nlp.annotators.context;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import ru.ispras.texterra.core.common.concept.Concept;
import ru.ispras.texterra.core.nlp.annotators.ISerializableAnnotator;
import ru.ispras.texterra.core.nlp.datamodel.AllDocumentMeaningsSemanticContext;
import ru.ispras.texterra.core.nlp.datamodel.INLPDocument;
import ru.ispras.texterra.core.nlp.datamodel.ISemanticContextValue;
import ru.ispras.texterra.core.nlp.datamodel.MeaningPhrase;
import ru.ispras.texterra.core.nlp.datamodel.SemanticContextValue;

public final class AllDocumentConceptsContextAnnotator
implements ISerializableAnnotator<AllDocumentMeaningsSemanticContext> {
    private static final long serialVersionUID = 5116136052149305372L;

    @Override
    public Collection<AllDocumentMeaningsSemanticContext> annotate(INLPDocument doc) {
        HashSet<Concept> setOfAllConcepts = new HashSet<Concept>();
        for (MeaningPhrase frame : doc.getAnnotations(MeaningPhrase.class)) {
            Set<Concept> meanings = frame.getMeanings();
            setOfAllConcepts.addAll(meanings);
        }
        return Collections.singletonList(new AllDocumentMeaningsSemanticContext(doc, (ISemanticContextValue)new SemanticContextValue((Set<Concept>)setOfAllConcepts)));
    }
}

