/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.nlp.annotators.chains;

import java.util.Collections;
import java.util.Iterator;
import ru.ispras.ml.pipelines.PredictionPipeline;
import ru.ispras.ml.pipelines.SourceLabelPair;
import ru.ispras.texterra.core.nlp.annotators.IAnnotatorTrainer;
import ru.ispras.texterra.core.nlp.annotators.chains.ChainAnnotator;
import ru.ispras.texterra.core.nlp.annotators.chains.InDocumentSourcesTargetsIterator;
import ru.ispras.texterra.core.nlp.annotators.ml.pipelines.PredictionPipelineTrainer;
import ru.ispras.texterra.core.nlp.datamodel.IAnnotation;
import ru.ispras.texterra.core.nlp.datamodel.INLPDocument;
import ru.ispras.texterra.core.nlp.datamodel.NLPDocumentWithAnnotation;

public final class ChainAnnotatorTrainer<SA extends IAnnotation, TA extends IAnnotation, L>
implements IAnnotatorTrainer<ChainAnnotator<SA, TA, L>> {
    private final PredictionPipelineTrainer<NLPDocumentWithAnnotation<SA>, L> trainer;
    private final ChainAnnotator.IAnnotationLabelConverter<TA, L> converter;
    private final Class<SA> sourceType;
    private final Class<TA> targetType;

    public ChainAnnotatorTrainer(PredictionPipelineTrainer<NLPDocumentWithAnnotation<SA>, L> trainer, ChainAnnotator.IAnnotationLabelConverter<TA, L> converter, Class<SA> sourceType, Class<TA> targetType) {
        this.trainer = trainer;
        this.converter = converter;
        this.sourceType = sourceType;
        this.targetType = targetType;
    }

    @Override
    public ChainAnnotator<SA, TA, L> train(Iterable<INLPDocument> documents) {
        PredictionPipeline<NLPDocumentWithAnnotation<SA>, L> predictor = this.trainer.train(new SourcesLabelsIterable<SA, TA, L>(this.converter, documents, this.sourceType, this.targetType));
        return new ChainAnnotator<SA, TA, L>(predictor, this.converter, this.sourceType);
    }

    private static final class SourcesTargetsIterator<SA extends IAnnotation, TA extends IAnnotation, L>
    implements Iterator<SourceLabelPair<NLPDocumentWithAnnotation<SA>, L>> {
        private final ChainAnnotator.IAnnotationLabelConverter<TA, L> converter;
        private final Iterator<INLPDocument> documentsIt;
        private final Class<SA> sourceType;
        private final Class<TA> targetType;
        private Iterator<SourceLabelPair<NLPDocumentWithAnnotation<SA>, L>> inDocumentIt = Collections.emptyList().iterator();

        public SourcesTargetsIterator(ChainAnnotator.IAnnotationLabelConverter<TA, L> converter, Iterator<INLPDocument> documentsIt, Class<SA> sourceType, Class<TA> targetType) {
            this.converter = converter;
            this.documentsIt = documentsIt;
            this.sourceType = sourceType;
            this.targetType = targetType;
            this.advanceIfNeeded();
        }

        @Override
        public boolean hasNext() {
            return this.inDocumentIt.hasNext();
        }

        @Override
        public SourceLabelPair<NLPDocumentWithAnnotation<SA>, L> next() {
            SourceLabelPair<NLPDocumentWithAnnotation<SA>, L> result = this.inDocumentIt.next();
            this.advanceIfNeeded();
            return result;
        }

        private void advanceIfNeeded() {
            while (!this.inDocumentIt.hasNext() && this.documentsIt.hasNext()) {
                INLPDocument doc = this.documentsIt.next();
                this.inDocumentIt = new InDocumentSourcesTargetsIterator<SA, TA, L>(this.converter, doc, this.sourceType, this.targetType);
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static final class SourcesLabelsIterable<SA extends IAnnotation, TA extends IAnnotation, L>
    implements Iterable<SourceLabelPair<NLPDocumentWithAnnotation<SA>, L>> {
        private final ChainAnnotator.IAnnotationLabelConverter<TA, L> converter;
        private final Iterable<INLPDocument> documents;
        private final Class<SA> sourceType;
        private final Class<TA> targetType;

        public SourcesLabelsIterable(ChainAnnotator.IAnnotationLabelConverter<TA, L> converter, Iterable<INLPDocument> documents, Class<SA> sourceType, Class<TA> targetType) {
            this.converter = converter;
            this.documents = documents;
            this.sourceType = sourceType;
            this.targetType = targetType;
        }

        @Override
        public Iterator<SourceLabelPair<NLPDocumentWithAnnotation<SA>, L>> iterator() {
            return new SourcesTargetsIterator<SA, TA, L>(this.converter, this.documents.iterator(), this.sourceType, this.targetType);
        }
    }
}

