/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.nlp.annotators;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import ru.ispras.texterra.core.nlp.annotators.ISerializableAnnotator;
import ru.ispras.texterra.core.nlp.datamodel.IAnnotation;
import ru.ispras.texterra.core.nlp.datamodel.INLPDocument;
import ru.ispras.texterra.core.nlp.datamodel.IToken;
import ru.ispras.texterra.core.nlp.datamodel.IValuedAnnotation;
import ru.ispras.texterra.core.nlp.datamodel.ModifiedTextToken;

public class TextReplaceAnnotator<T extends IAnnotation>
implements ISerializableAnnotator<IToken> {
    private static final long serialVersionUID = -8381307224486754038L;
    private final Class<T> sourceType;
    private final ITextExtractionStrategy<? super T> extractionStrategy;

    public TextReplaceAnnotator(Class<T> sourceType, ITextExtractionStrategy<? super T> extractionStrategy) {
        this.sourceType = sourceType;
        this.extractionStrategy = extractionStrategy;
    }

    @Override
    public Collection<IToken> annotate(INLPDocument doc) {
        ArrayList<IToken> result = new ArrayList<IToken>();
        for (IAnnotation annotation : doc.getAnnotations(this.sourceType)) {
            String modifiedText = this.extractionStrategy.makeText(annotation);
            result.add(new ModifiedTextToken(annotation, modifiedText));
        }
        return result;
    }

    public static class FixedValueStrategy
    implements ITextExtractionStrategy<IAnnotation> {
        private static final long serialVersionUID = 6654252657589111854L;
        private final String text;

        public FixedValueStrategy(String text) {
            this.text = text;
        }

        @Override
        public String makeText(IAnnotation annotation) {
            return this.text;
        }
    }

    public static class EmptyValueStrategy
    implements ITextExtractionStrategy<IAnnotation> {
        private static final long serialVersionUID = 6654252657589111854L;
        private static final String empty = "";

        @Override
        public String makeText(IAnnotation annotation) {
            return empty;
        }
    }

    public static class GetValueStrategy
    implements ITextExtractionStrategy<IValuedAnnotation<String>> {
        private static final long serialVersionUID = -4928691540444058652L;

        @Override
        public String makeText(IValuedAnnotation<String> annotation) {
            return annotation.getValue();
        }
    }

    public static interface ITextExtractionStrategy<T extends IAnnotation>
    extends Serializable {
        public String makeText(T var1);
    }
}

