/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.nlp.annotators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import ru.ispras.texterra.core.nlp.annotators.ISerializableAnnotator;
import ru.ispras.texterra.core.nlp.datamodel.Capitalisation;
import ru.ispras.texterra.core.nlp.datamodel.INLPDocument;
import ru.ispras.texterra.core.nlp.datamodel.IToken;

public class NonAcronymCapitalisationAnnotator
implements ISerializableAnnotator<Capitalisation> {
    private static final long serialVersionUID = -5915657722547866256L;
    private final Set<String> acronyms;

    public NonAcronymCapitalisationAnnotator(Set<String> acronyms) {
        this.acronyms = acronyms;
    }

    @Override
    public Collection<Capitalisation> annotate(INLPDocument doc) {
        ArrayList<Capitalisation> result = new ArrayList<Capitalisation>();
        for (IToken token : doc.getAnnotations(IToken.class)) {
            String tokenString = (String)token.getValue();
            if (!this.isCapitalisation(tokenString) || this.acronyms.contains(tokenString)) continue;
            result.add(new Capitalisation(token));
        }
        return result;
    }

    private boolean isCapitalisation(String token) {
        return token.length() >= 3 && token.equals(token.toUpperCase());
    }
}

