/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.nlp.annotators;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ru.ispras.texterra.core.nlp.annotators.ISerializableAnnotator;
import ru.ispras.texterra.core.nlp.datamodel.INLPDocument;
import ru.ispras.texterra.core.nlp.datamodel.Paragraph;

public final class NaiveParagraphDetector
implements ISerializableAnnotator<Paragraph> {
    private static final long serialVersionUID = -3864131847162126301L;
    private static final Pattern lineFeedPattern = Pattern.compile("\\n+");

    @Override
    public Collection<Paragraph> annotate(INLPDocument doc) {
        LinkedList<Paragraph> result = new LinkedList<Paragraph>();
        String text = doc.getText();
        Matcher lineFeedMatcher = lineFeedPattern.matcher(text);
        int start = 0;
        while (lineFeedMatcher.find()) {
            this.addParagraph(result, doc, start, lineFeedMatcher.start());
            start = lineFeedMatcher.end();
        }
        this.addParagraph(result, doc, start, text.length());
        return result;
    }

    private void addParagraph(List<Paragraph> result, INLPDocument doc, int start, int end) {
        if (end > start) {
            result.add(new Paragraph(doc, start, end));
        }
    }
}

