/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.nlp.annotators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.Validate;
import ru.ispras.texterra.core.nlp.annotators.ISerializableAnnotator;
import ru.ispras.texterra.core.nlp.datamodel.IAnnotation;
import ru.ispras.texterra.core.nlp.datamodel.INLPDocument;
import ru.ispras.texterra.core.nlp.datamodel.NGram;

public abstract class AbstractNGramAnnotator<T extends IAnnotation>
implements ISerializableAnnotator<NGram<T>> {
    private static final long serialVersionUID = -3371401073702259439L;
    private final Class<T> unigramType;
    private final int minSize;
    private final int maxSize;

    public AbstractNGramAnnotator(Class<T> unigramType, int minSize, int maxSize) {
        this.unigramType = unigramType;
        Validate.isTrue((minSize > 0 ? 1 : 0) != 0, (String)"Minimal size should be positive.");
        Validate.isTrue((minSize <= maxSize ? 1 : 0) != 0, (String)"Minimal size should be less or equal than maximal.");
        this.minSize = minSize;
        this.maxSize = maxSize;
    }

    public AbstractNGramAnnotator(Class<T> type, int size) {
        this(type, size, size);
    }

    @Override
    public Collection<NGram<T>> annotate(INLPDocument doc) {
        ArrayList<NGram<T>> result = new ArrayList<NGram<T>>();
        for (int size = this.minSize; size <= this.maxSize; ++size) {
            List<T> unigrams = this.getUnigrams(doc, size);
            for (int i = 0; i <= unigrams.size() - size; ++i) {
                List<T> ngram = unigrams.subList(i, i + size);
                result.add(new NGram<T>(doc, ((IAnnotation)ngram.get(0)).getStart(), ((IAnnotation)ngram.get(ngram.size() - 1)).getEnd(), ngram));
            }
        }
        return result;
    }

    private List<T> getUnigrams(INLPDocument doc, int size) {
        int i;
        ArrayList<T> result = new ArrayList<T>();
        for (i = 0; i < size - 1; ++i) {
            result.add(this.create(doc, 0, 0));
        }
        result.addAll(doc.getAnnotations(this.unigramType));
        for (i = 0; i < size - 1; ++i) {
            result.add(this.create(doc, doc.getText().length(), doc.getText().length()));
        }
        return result;
    }

    protected abstract T create(INLPDocument var1, int var2, int var3);
}

