/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.ekb.similarity.linkweight;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import ru.ispras.texterra.core.ekb.interfaces.ILinkWeightComputer;
import ru.ispras.texterra.utils.datamodel.Link;

public abstract class AbstractLinkWeightComputer
implements ILinkWeightComputer {
    private static final long serialVersionUID = 407841166918440989L;
    private static final double[] defaultWeights = AbstractLinkWeightComputer.computeDefaultWeights();
    protected double[] weights;

    public static final double[] computeDefaultWeights() {
        HashMap<Link.Type, Double> type2weight = new HashMap<Link.Type, Double>();
        type2weight.put(Link.Type.SEE_ALSO, 0.192328818880988);
        type2weight.put(Link.Type.BACK_SEE_ALSO, 0.168697457909713);
        type2weight.put(Link.Type.RELATED, 0.19173175041984);
        type2weight.put(Link.Type.BACK_RELATED, 0.1154870750417);
        type2weight.put(Link.Type.BACK_CATEGORY, 0.018515882306914);
        type2weight.put(Link.Type.CATEGORY, 0.066377608631378);
        type2weight.put(Link.Type.DOUBLE, 0.159028442657649);
        type2weight.put(Link.Type.REGULAR, 0.001118747524812);
        type2weight.put(Link.Type.BACK_REGULAR, 0.070585573272675);
        type2weight.put(Link.Type.INFO_BOX, 0.005123618024276);
        type2weight.put(Link.Type.BACK_INFO_BOX, 0.003746855140457);
        double[] result = new double[Link.Type.values().length];
        Arrays.fill(result, 0.0);
        for (Map.Entry typeAndWeight : type2weight.entrySet()) {
            result[((Link.Type)((Object)typeAndWeight.getKey())).ordinal()] = (Double)typeAndWeight.getValue();
        }
        return result;
    }

    public AbstractLinkWeightComputer() {
        this.weights = defaultWeights;
    }

    public AbstractLinkWeightComputer(double[] w) {
        this.weights = Arrays.copyOf(w, w.length);
    }

    protected abstract double computeWeight(int var1);

    @Override
    public double computeLinkWeight(int bitmap, int srcCardinality, int trgCardinality) {
        double weight = this.computeWeight(bitmap);
        double maxCardinality = Math.max((double)Math.max(srcCardinality, trgCardinality), 1.0);
        return weight / maxCardinality;
    }

    public boolean equals(Object comp) {
        boolean res;
        if (comp == null) {
            return false;
        }
        boolean bl = res = comp.getClass() == this.getClass();
        if (!res) {
            return false;
        }
        AbstractLinkWeightComputer abstrLWC = (AbstractLinkWeightComputer)comp;
        for (int i = 0; i < this.weights.length; ++i) {
            res &= Double.compare(this.weights[i], abstrLWC.weights[i]) == 0;
        }
        return res;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        for (double d : this.weights) {
            long dhash = Double.doubleToLongBits(d);
            hash ^= (int)(dhash ^ dhash >>> 32);
        }
        return hash;
    }
}

