/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.ekb.similarity;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.simpleframework.xml.ElementArray;
import org.simpleframework.xml.ElementMap;
import ru.ispras.texterra.core.common.concept.Concept;

public class FullSimilarityGraph
implements Serializable {
    private static final long serialVersionUID = -5058427329613068831L;
    @ElementMap(name="concept2position")
    private Map<Concept, Integer> concept2position;
    @ElementArray(name="similarity")
    private double[][] similarity;

    protected FullSimilarityGraph(List<Concept> concepts, double[][] sim) {
        int size = concepts.size();
        this.concept2position = new HashMap<Concept, Integer>(size);
        for (int i = 0; i < size; ++i) {
            this.concept2position.put(concepts.get(i), i);
        }
        this.similarity = sim;
    }

    protected FullSimilarityGraph(@ElementMap(name="concept2position") Map<Concept, Integer> concept2position, @ElementArray(name="similarity") double[][] similarity) {
        this.concept2position = concept2position;
        this.similarity = similarity;
    }

    public double getSimilarity(Concept c1, Concept c2) {
        int max;
        int min;
        if (c1.equals(c2)) {
            return 1.0;
        }
        Integer pos1 = this.concept2position.get(c1);
        Integer pos2 = this.concept2position.get(c2);
        if (pos1 == null || pos2 == null) {
            return 0.0;
        }
        if (pos1 < pos2) {
            min = pos1;
            max = pos2;
        } else {
            min = pos2;
            max = pos1;
        }
        return this.similarity[min][max - min - 1];
    }

    public List<Concept> getConcepts() {
        return new ArrayList<Concept>(this.concept2position.keySet());
    }
}

