/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.configuration.provider;

import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.configuration.CombinedConfiguration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.commons.configuration.tree.ConfigurationNode;
import org.apache.commons.configuration.tree.NodeCombiner;
import org.apache.commons.configuration.tree.ViewNode;
import ru.ispras.texterra.core.configuration.provider.IConfigurationProvider;
import ru.ispras.texterra.core.exceptions.TexterraConfigException;

public final class ClasspathConfigurationProvider
implements IConfigurationProvider {
    private final String resource;

    public ClasspathConfigurationProvider(String resource) {
        this.resource = resource;
    }

    @Override
    public Collection<? extends HierarchicalConfiguration> createConfigurations() throws TexterraConfigException {
        Enumeration<URL> urls = ClasspathConfigurationProvider.getResources(this.resource);
        if (!urls.hasMoreElements()) {
            throw new TexterraConfigException("Resource from classpath not found: " + this.resource);
        }
        CombinedConfiguration result = new CombinedConfiguration((NodeCombiner)new MergeRootsCombiner());
        DisjunctiveConfigurationsVerifier verifier = new DisjunctiveConfigurationsVerifier();
        while (urls.hasMoreElements()) {
            URL url = urls.nextElement();
            XMLConfiguration config = this.createConfiguration(url);
            verifier.verifyNoDuplicates((HierarchicalConfiguration)config, url);
            result.addConfiguration((AbstractConfiguration)config);
        }
        return Collections.singletonList(result);
    }

    private XMLConfiguration createConfiguration(URL url) {
        try {
            return new XMLConfiguration(url);
        }
        catch (ConfigurationException e) {
            throw new TexterraConfigException(e);
        }
    }

    private static Enumeration<URL> getResources(String resource) {
        ClassLoader loader = ClasspathConfigurationProvider.getClassLoader();
        try {
            return loader.getResources(resource);
        }
        catch (IOException e) {
            throw new TexterraConfigException(e);
        }
    }

    private static ClassLoader getClassLoader() {
        ClassLoader loader = ClasspathConfigurationProvider.class.getClassLoader();
        if (loader == null) {
            loader = ClassLoader.getSystemClassLoader();
        }
        return loader;
    }

    @Override
    public String getConfigurationSourceDescription() {
        return "Classpath resource: '" + this.resource + "'";
    }

    private static final class DisjunctiveConfigurationsVerifier {
        private static final Pattern ATTRIBUTE_PATTERN = Pattern.compile("^(^.*)(?:\\[@[^]]+\\]$)");
        private Map<String, URL> knownClasses = new HashMap<String, URL>();

        private DisjunctiveConfigurationsVerifier() {
        }

        public void verifyNoDuplicates(HierarchicalConfiguration config, URL url) {
            HashMap<String, URL> current = new HashMap<String, URL>();
            Iterator propertyIterator = config.getKeys();
            while (propertyIterator.hasNext()) {
                String property = (String)propertyIterator.next();
                if (this.isAttribute(property)) continue;
                String className = this.toClassName(property);
                if (this.knownClasses.containsKey(className)) {
                    throw new TexterraConfigException("Duplicate class " + className + " configuration: " + this.knownClasses.get(className) + " and " + url);
                }
                current.put(className, url);
            }
            this.knownClasses.putAll(current);
        }

        private boolean isAttribute(String property) {
            return ATTRIBUTE_PATTERN.matcher(property).matches();
        }

        private String toClassName(String property) {
            int index = property.lastIndexOf(46);
            if (index < 0) {
                throw new TexterraConfigException("Cannot find class name, given property: " + property);
            }
            return property.substring(0, index);
        }
    }

    private static final class MergeRootsCombiner
    extends NodeCombiner {
        private MergeRootsCombiner() {
        }

        public ConfigurationNode combine(ConfigurationNode first, ConfigurationNode second) {
            ViewNode result = this.createViewNode();
            result.setName(first.getName());
            result.appendAttributes(first);
            result.appendChildren(first);
            result.appendChildren(second);
            return result;
        }
    }
}

