/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.configuration;

import java.io.File;
import java.util.ArrayList;
import ru.ispras.texterra.core.configuration.TexterraConfiguration;
import ru.ispras.texterra.core.configuration.provider.ClasspathConfigurationProvider;
import ru.ispras.texterra.core.configuration.provider.FromEnvironmentVariableConfigurationProvider;
import ru.ispras.texterra.core.configuration.provider.FromFileConfigurationProvider;
import ru.ispras.texterra.core.configuration.provider.FromSystemPropertiesConfigurationProvider;
import ru.ispras.texterra.core.configuration.provider.FromSystemPropertyFilesConfigurationProvider;
import ru.ispras.texterra.core.configuration.provider.IConfigurationProvider;
import ru.ispras.texterra.core.exceptions.TexterraConfigException;

public final class TexterraConfigurationFactory {
    public static final String SYSTEM_PROPERTY = "texterra.properties.xml";
    public static final String ENVIRONMENT_VARIABLE = "TEXTERRA_PROPERTIES";
    private static final String SYSTEM_PROPERTIES_FILE = "/etc/texterra/texterra.properties.xml";
    private static TexterraConfiguration configuration = null;

    public static synchronized TexterraConfiguration getConfiguration() throws TexterraConfigException {
        if (configuration == null) {
            configuration = TexterraConfigurationFactory.createConfiguration();
        }
        return configuration;
    }

    private static TexterraConfiguration createConfiguration() throws TexterraConfigException {
        ArrayList<IConfigurationProvider> providers = new ArrayList<IConfigurationProvider>();
        providers.add(new FromSystemPropertiesConfigurationProvider("ru.ispras.texterra"));
        providers.add(new FromSystemPropertyFilesConfigurationProvider(SYSTEM_PROPERTY));
        providers.add(new FromEnvironmentVariableConfigurationProvider(ENVIRONMENT_VARIABLE));
        if (new File(SYSTEM_PROPERTIES_FILE).exists()) {
            providers.add(new FromFileConfigurationProvider(SYSTEM_PROPERTIES_FILE));
        }
        providers.add(new ClasspathConfigurationProvider(SYSTEM_PROPERTY));
        return new TexterraConfiguration(providers);
    }
}

