/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.common.concept;

import java.util.ArrayList;
import java.util.List;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;
import ru.ispras.texterra.core.common.concept.IAttribute;
import ru.ispras.texterra.core.exceptions.TexterraSystemException;

@Root
public final class TranslationAttribute
implements IAttribute {
    private static final long serialVersionUID = 8909269616405245928L;
    @Element(name="lang")
    private final String lang;
    @ElementList(name="translations")
    private List<String> translations = new ArrayList<String>();

    public TranslationAttribute(String la) {
        this.lang = la;
    }

    public TranslationAttribute(@Element(name="lang") String lang, @ElementList(name="translations") List<String> translations) {
        this.lang = lang;
        this.translations = translations;
    }

    public String getTranslationLanguage() {
        return this.lang;
    }

    public List<String> getTranslations() {
        return this.translations;
    }

    public void addTranslation(String translation) {
        this.translations.add(translation);
    }

    @Override
    public TranslationAttribute clone() {
        try {
            TranslationAttribute translAttr = (TranslationAttribute)super.clone();
            translAttr.translations = new ArrayList<String>(this.translations);
            return translAttr;
        }
        catch (CloneNotSupportedException cloneExc) {
            throw new TexterraSystemException(cloneExc);
        }
    }
}

