/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.common.concept;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;
import ru.ispras.texterra.core.common.concept.IAttribute;
import ru.ispras.texterra.core.exceptions.TexterraSystemException;

@Root
public final class SynonymAttribute
implements IAttribute {
    private static final long serialVersionUID = -5207854845263076954L;
    @ElementList(inline=true)
    private List<Pair> synonyms = new ArrayList<Pair>();

    public SynonymAttribute() {
    }

    public SynonymAttribute(@ElementList(inline=true) List<Pair> synonyms) {
        this.synonyms = synonyms;
    }

    public void addSynonym(String syn, double w) {
        this.synonyms.add(new Pair(syn, w));
    }

    public List<Pair> getSynonyms() {
        return this.synonyms;
    }

    @Override
    public SynonymAttribute clone() {
        try {
            SynonymAttribute synAttr = (SynonymAttribute)super.clone();
            synAttr.synonyms = new ArrayList<Pair>(this.synonyms);
            return synAttr;
        }
        catch (CloneNotSupportedException cloneExc) {
            throw new TexterraSystemException(cloneExc);
        }
    }

    @Root
    public static class Pair
    implements Serializable {
        private static final long serialVersionUID = 1499378814841846308L;
        @Element(name="synonym")
        String synonym;
        @Element(name="weight")
        double weight;

        public Pair(@Element(name="synonym") String synonym, @Element(name="weight") double weight) {
            this.synonym = synonym;
            this.weight = weight;
        }

        public String getSynonym() {
            return this.synonym;
        }

        public double getWeight() {
            return this.weight;
        }

        public String toString() {
            return "<" + this.synonym + ", " + this.weight + ">";
        }
    }
}

