/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.common.concept;

import java.io.Serializable;
import org.apache.commons.lang.Validate;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.Order;
import org.simpleframework.xml.Root;

@Root(name="concept", strict=false)
@Order(elements={"id", "kbname"})
public final class Concept
implements Serializable,
Comparable<Concept> {
    private static final long serialVersionUID = -1435026326520145193L;
    private final String kbName;
    private final int id;

    public Concept(@Element(name="kbname") String kbName, @Element(name="id") int id) {
        Validate.notNull((Object)kbName, (String)"KB name should not be null.");
        Validate.isTrue((id >= 0 ? 1 : 0) != 0, (String)"id should be non-negative");
        this.kbName = kbName;
        this.id = id;
    }

    @Element(name="kbname")
    public String getKbName() {
        return this.kbName;
    }

    @Element(name="id")
    public int getId() {
        return this.id;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.id;
        result = 31 * result + this.kbName.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Concept other = (Concept)obj;
        return this.id == other.id && this.kbName.equals(other.kbName);
    }

    @Override
    public int compareTo(Concept other) {
        int c = this.kbName.compareTo(other.kbName);
        if (c != 0) {
            return c;
        }
        return Integer.compare(this.id, other.id);
    }

    public String toString() {
        return "Concept [kbName=" + this.kbName + ", id=" + this.id + "]";
    }
}

