/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.common.concept;

import java.util.ArrayList;
import java.util.List;
import ru.ispras.texterra.core.common.concept.CoordinatesAttribute;
import ru.ispras.texterra.core.common.concept.DefinitionAttribute;
import ru.ispras.texterra.core.common.concept.IAttribute;
import ru.ispras.texterra.core.common.concept.MobileURLAttribute;
import ru.ispras.texterra.core.common.concept.SynonymAttribute;
import ru.ispras.texterra.core.common.concept.TitleAttribute;
import ru.ispras.texterra.core.common.concept.TranslationAttribute;
import ru.ispras.texterra.core.common.concept.TypeAttribute;

public final class AttributesFactory {
    private List<IAttribute> attributes = new ArrayList<IAttribute>();

    public AttributesFactory addSynonymsAttribute() {
        this.attributes.add(new SynonymAttribute());
        return this;
    }

    public AttributesFactory addTranslationAttribute(String lang) {
        this.attributes.add(new TranslationAttribute(lang));
        return this;
    }

    public AttributesFactory addTitleAttribute() {
        this.attributes.add(new TitleAttribute());
        return this;
    }

    public AttributesFactory addMobileURLAttribute(String lang) {
        this.attributes.add(new MobileURLAttribute(lang));
        return this;
    }

    public AttributesFactory addAttribute(IAttribute att) {
        this.attributes.add(att);
        return this;
    }

    public AttributesFactory addCoordinatesAttribute() {
        this.attributes.add(new CoordinatesAttribute());
        return this;
    }

    public AttributesFactory addDefinitionAttribute() {
        this.attributes.add(new DefinitionAttribute());
        return this;
    }

    public AttributesFactory addTypeAttribute() {
        this.attributes.add(new TypeAttribute());
        return this;
    }

    public List<IAttribute> toAttributeList() {
        return this.attributes;
    }
}

