/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.common.concept;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementArray;
import org.simpleframework.xml.Root;
import ru.ispras.texterra.core.common.concept.Concept;
import ru.ispras.texterra.core.common.concept.IAttribute;

@Root
public final class AttributedConcept
implements Serializable {
    private static final long serialVersionUID = 3800754677667650445L;
    @ElementArray(name="attributes")
    private IAttribute[] attr;
    @Element(name="concept")
    private Concept concept;

    public AttributedConcept(@Element(name="concept") Concept c, @ElementArray(name="attributes") IAttribute[] attr) {
        this.concept = c;
        this.attr = attr;
    }

    public <A extends IAttribute> A getAttribute(Class<A> cl) {
        for (IAttribute a : this.attr) {
            if (!a.getClass().equals(cl)) continue;
            return (A)a;
        }
        return null;
    }

    public <A extends IAttribute> List<A> getAllAttributes(Class<A> cl) {
        ArrayList<IAttribute> result = new ArrayList<IAttribute>();
        for (IAttribute a : this.attr) {
            if (!a.getClass().equals(cl)) continue;
            result.add(a);
        }
        return result;
    }

    public List<IAttribute> getAllAttributes() {
        return new ArrayList<IAttribute>(Arrays.asList(this.attr));
    }

    public Concept getConcept() {
        return this.concept;
    }
}

